﻿using System;
using ChatClient.ChatService;
using System.ServiceModel;

namespace ChatClient
{
    class Program
    {
        static void Main(string[] args)
        {
            ChatCallback callbackObject = new ChatCallback();
            InstanceContext clientContext = new InstanceContext(callbackObject);
            ChatServiceClient chatProxy = new ChatServiceClient(clientContext);

            Console.WriteLine("Proszę wprowadzić imię:");
            bool ok = false;
            while (!ok)
            {
                string name = Console.ReadLine();
                ok = chatProxy.Connect(name);
                if (!ok)
                {
                    Console.WriteLine("To imię jest już używane. Proszę spróbować podać inne.");
                }
            }
            while (true)
            {
                Console.WriteLine("Napisz notatkę (lub naciśnij klawisz Enter, aby zakończyć działanie programu):");
                string note = Console.ReadLine();
                if (string.IsNullOrEmpty(note))
                {
                    break;
                }
                chatProxy.PostNote(note);
            }
            chatProxy.Disconnect();
        }
    }
}
